unit DFilterMainData01;
(*
   ========================================================================
    " " DFiltr.
         .
   ========================================================================
   :
   1.  ,    
   2.        .
   3.     MicroBase
   4.   
   ========================================================================
    
   ()  ,    , , .
   ========================================================================
       
   ()   , ,  
   ========================================================================
*)

interface

uses  //  
      Classes, SysUtils, StdCtrls, Grids,
     //        
      EngineMainData01, MainData;

// ========================================================================
// 03.02.2013
const //        
      DFilterMaxLen   = 7;
      //        
      DFilterFocusRC  = DFilterMaxLen div 2;

// 03.02.2013
type //  ,    
     ptDFiltrArray = ^TDFiltrArray;
     TDFiltrArray  = array [0..DFilterMaxLen-1, 0..DFilterMaxLen-1] of integer;

// ========================================================================
//      
// ========================================================================
// 03.02.2013
//    - MicroBase     DFiltrScale,
//   DFiltrType  DFiltrArray. ,   MicroBase,
//        .
//
var  MbSetFilter : boolean;

// 03.02.2013
//        
var
     DFiltrArray : TDFiltrArray;     //   
     DFiltrScale : integer;          //   

// 03.02.2013
//  MicroBase    
var
     DFiltrType  : integer;          //   
     DFilterName : string[80];       //  

// ========================================================================
//    BGR- 
// ========================================================================
// 03.02.2013
var  //     
     ArrFragSrcBGR : TImgTabBGR; // array of array of byte;

// 03.02.2013
var  //     
     ArrFragTrgBGR  : TImgTabBGR; // array of array of byte;

// ========================================================================
//       
// ========================================================================

// 03.02.2013
var //   Color-  
    ImgTabColorSrc  : TImgTabColor; // array of array of TColorByte;

// 03.02.2013
var //   Color-  
    ImgTabColorTrg  : TImgTabColor; // array of array of TColorByte;

// ========================================================================
//    
// ========================================================================

//      
procedure ClearDFiltrArray(var RqFArr  : TDFiltrArray);

//    
procedure SetCopyDFiltrArray(var  RqFArr  : TDFiltrArray;
                             var  RqScale : integer;
                                  RqVal   : integer);

//    
procedure ShowDFiltrArray(RqSGrid : TStringGrid;
                          RqFArr  : TDFiltrArray);

//    
procedure ShowDFiltrScale(RqEdit : TEdit; RqScale : integer);

// ========================================================================
implementation
// ========================================================================
// 23.02.2013
//      
procedure ClearDFiltrArray(var RqFArr  : TDFiltrArray);
var WRow, WCol : integer;
begin
  for WRow := Low(RqFArr) to High(RqFArr) do
  begin
     for WCol := Low(RqFArr[WRow]) to High(RqFArr[WRow])
         do //    
         RqFArr [WRow, WCol] := 0;
  end;
end;
//-------------------------------------------------------------------------
// 23.02.2013
//    
procedure SetCopyDFiltrArray(var  RqFArr  : TDFiltrArray;
                                          var  RqScale : integer;
                                               RqVal   : integer);
begin
  ClearDFiltrArray(RqFArr);
  if RqVal > 0
  then begin
    RqFArr [DFilterFocusRC, DFilterFocusRC] := RqVal;
    RqScale := RqVal;
  end
  else begin
    RqFArr [DFilterFocusRC, DFilterFocusRC] := 1;
    RqScale := 1;
  end;
end;
//-------------------------------------------------------------------------
// 23.02.2013
//    
//   StringGrid   onSetEditText,
//     
procedure ShowDFiltrArray(RqSGrid : TStringGrid;
                                       RqFArr  : TDFiltrArray);
var WRow, WCol : integer;
begin
   with RqSGrid do
   begin
      for WRow := Low(RqFArr) to High(RqFArr) do
      begin
          for WCol := Low(RqFArr[WRow]) to High(RqFArr[WRow])
          do begin
            //   
            if RqFArr [WRow, WCol] <> 0
            then Cells[WCol, WRow] := IntToStr(RqFArr[WRow, WCol])
            else Cells[WCol, WRow] := '';
          end;
      end;
   end;
end;
//-------------------------------------------------------------------------
// 23.02.2013
//    
procedure ShowDFiltrScale(RqEdit : TEdit; RqScale : integer);
var SaveOnChange : TNotifyEvent;
begin
  //    OnChange
  SaveOnChange := RqEdit.OnChange;
  RqEdit.OnChange := nil;
  RqEdit.Text := IntToStr(RqScale); //  
  RqEdit.OnChange := SaveOnChange;
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
